*
* Program for discussion of Bernanke-Mihov paper
*
cal 1947 1 12
all 1996:12
************************************************************
*               DEFINITIONS
************************************************************
compute IPERIOD    = 1
compute LAGS       = 13
compute NSTEP      = 48
compute NDRAWS     = 5000
compute NPOLICY    = 3
compute NNONPOLICY = 3
*
compute NVAR       = NPOLICY+NNONPOLICY
DEC vect[labels] implab(nvar)
input IMPLAB
  GDP PGDP PCOM TR NBR FFR

*************************************************************
*   DATA Transformation
*************************************************************
*
*  Reserves
*
open data bmdata.rat
data(format=rats) 1959:1 1996:12 TRES NBREC FYFF PSCCOM
*
* Interpolated monthly variables: GDP and PGDP
*
data(format=rats) 1965:1 1996:12 gdpm pgdpm

*
* Take logs
*
log psccom
log gdpm
log pgdpm

**********  36-month MA normalization

mvstats(means=trma,span=36) tres 1961:12 1996:12
set TR1 1962:1 1996:12 = tres/trma{1}
set NBREC1 1962:1 1996:12 = nbrec/trma{1}

***** Set up the sample range

DEC vector[integer] date1(3) date2(3)
compute date1 = ||1966:2,  1966:2, 1979:10||
compute date2 = ||1996:12, 1979:9, 1996:12||

******************************************************************
*                  ESTIMATION
******************************************************************

***** Set up the system
SYSTEM(model=bmmodel)
variables gdpm pgdpm psccom tr1 nbrec1 fyff
lags 1 to lags
det constant
END(system)

estimate(resids=u0,noprint) date1(IPERIOD) date2(IPERIOD)
compute xxx=%xx
*
* Bernanke-Mihov model
* Get 3x3 matrix of monetary sector shocks with the three other
* variables swept out.
*
compute sweepvcv=%sweeptop(%sigma,NNONPOLICY)
compute [symm] moneyvcv=%xsubmat(sweepvcv,NNONPOLICY+1,NVAR,NNONPOLICY+1,NVAR)
*
dec frml[rect] ab phi
nonlin alpha beta phid phib
frml ab = ||1.0,0.0,alpha|1.0,-1.0,-beta|0.0,1.0,0.0||
frml phi = ||1.0,0.0,0.0|0.0,1.0,0.0|phid,phib,1.0||
*
disp 'JI (Just Identified)'
nonlin alpha=0 beta phid phib
compute phid=1.0,phib=-1.0,beta=0.0
cvmodel(pmethod=simplex,piters=10) moneyvcv ab phi

disp 'FFR Model'
nonlin alpha beta phid=1 phib=-1
cvmodel(pmethod=simplex,piters=10) moneyvcv ab phi
*
disp 'NBR Model'
nonlin alpha beta phid=0 phib=0
compute alpha=.03,beta=.014
cvmodel(pmethod=genetic,piters=100,factor=f) moneyvcv ab phi
*
disp 'NBR/TR Model (Orthogonalized NBR)'
nonlin alpha=0 beta phid phib=0
cvmodel(pmethod=simplex,piters=10) moneyvcv ab phi
*
disp 'BR Model'
nonlin alpha beta phid=1 phib=alpha/beta
cvmodel(pmethod=simplex,piters=10) moneyvcv ab phi
*
* Markov switching estimates
* The covariance matrix of the policy sector no longer forms
* sufficient statistics for the residuals; we need the residuals
* transformed to sweep out the contemporaneous effects of the
* other three. The rectangular block of sweepvcv in the rows for
* the policy variables and columns for the nonpolicy has the
* -1 x the coefficients of the transformations
*
dec vect[series] upolicy(NPOLICY) unon(NNONPOLICY)
do i=1,NNONPOLICY
   set unon(i) = u0(i)
end do i
do i=1,NPOLICY
   compute [vector] sweepco=%xsubmat(sweepvcv,NNONPOLICY+i,NNONPOLICY+i,1,NNONPOLICY)
   set upolicy(i) date1(IPERIOD) date2(IPERIOD) = u0(NNONPOLICY+i)+%dot(sweepco,%xt(unon,t))
end do i
*
* Two state Markov chain. The alpha is fixed at zero, beta takes a single value.
* The phi's and the variances are the parameters which change from state to state.
* Since the variances won't concentrate out, we switch to an alternative form which
* takes the u's to an identity matrix. The standard deviation scale factors will
* go into the "B" part of the Au=Bv expression.
*
dec rect p(1,2)
nonlin p beta phib_1 phid_1 d1_1 d2_1 d3_1 phib_2 phid_2 d1_2 d2_2 d3_2
source c:\rats\600exam\markov.src
dec frml[rect] phi_1 phi_2
frml ab = ||1.0,0.0,0.0|1.0,-1.0,-beta|0.0,1.0,0.0||
frml phi_1 = ||d1_1,0.0,0.0|0.0,d2_1,0.0|d1_1*phid_1,d2_1*phib_1,d3_1||
frml phi_2 = ||d1_2,0.0,0.0|0.0,d2_2,0.0|d1_2*phid_2,d2_2*phib_2,d3_2||
*
frml init = (pstar=%mcergodic(p)),$
            (siginv_1=%innerxx(inv(phi_1(1))*ab(1))),$
            (siginv_2=%innerxx(inv(phi_2(1))*ab(1))),$
            (det_1=log(abs(%det(siginv_1)))),(det_2=log(abs(%det(siginv_2))))
*
function StateF time
type vector StateF
type integer time
*
local vector u
compute u=%xt(upolicy,time)
compute StateF=||1.0/sqrt(2*%pi)*exp(.5*det_1-.5*%qform(siginv_1,u)),1.0/sqrt(2*%pi)*exp(.5*det_2-.5*%qform(siginv_2,u))||
end
*
* The log likelihood function recursively calculates the vector pstar of estimated
* state probabilities. The likelihoods in the states and computed by the ARCHStateF
* function, and then %mcstate and %msupdate update the pstar vector and compute the
* likelihood. We use a start formula on maximize to start pstar at the ergodic
* probabilities.
*
compute p=||.5,.5||
compute phid_1=0.0,phib_1= 0.0,d1_1=sqrt(moneyvcv(1,1)),d2_1=sqrt(moneyvcv(2,2)),d3_1=sqrt(moneyvcv(3,3))
compute phid_2=1.0,phib_2=-1.0,d1_2=d1_1,d2_2=d2_1,d3_2=d3_1
*
set phist = 0.0
frml logl = f=StateF(t),pstar=%msupdate(f,%mcstate(p,pstar),fpt),phist(t)=pstar(1),log(fpt)
maximize(start=init,trace,pmethod=simplex,piters=50,method=bhhh,iters=400) logl date1(iperiod) date2(iperiod)
graph
# phist date1(iperiod) date2(iperiod)



